/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decodesignfunctionsandblocks.entity;

import net.mcreator.decodesignfunctionsandblocks.init.DecodesignFunctionsAndBlocksModEntities;
import net.mcreator.decodesignfunctionsandblocks.procedures.OysterPriObnovlieniiTikaSushchnostiProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class OysterEntity
extends PathfinderMob {
    public OysterEntity(EntityType<OysterEntity> type, Level world) {
        super(type, world);
        this.setMaxUpStep(0.6f);
        this.xpReward = 1;
        this.setNoAi(false);
        this.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (OysterEntity.this.isInWater()) {
                    OysterEntity.this.setDeltaMovement(OysterEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !OysterEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - OysterEntity.this.getX();
                    double dy = this.wantedY - OysterEntity.this.getY();
                    double dz = this.wantedZ - OysterEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * OysterEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    OysterEntity.this.setYRot(this.rotlerp(OysterEntity.this.getYRot(), f, 10.0f));
                    OysterEntity.this.yBodyRot = OysterEntity.this.getYRot();
                    OysterEntity.this.yHeadRot = OysterEntity.this.getYRot();
                    if (OysterEntity.this.isInWater()) {
                        OysterEntity.this.setSpeed((float)OysterEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        OysterEntity.this.setXRot(this.rotlerp(OysterEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(OysterEntity.this.getXRot() * ((float)Math.PI / 180)));
                        OysterEntity.this.setZza(f3 * f1);
                        OysterEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        OysterEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    OysterEntity.this.setSpeed(0.0f);
                    OysterEntity.this.setYya(0.0f);
                    OysterEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType getMobType() {
        return MobType.WATER;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void baseTick() {
        super.baseTick();
        OysterPriObnovlieniiTikaSushchnostiProcedure.execute((Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OysterEntity entity = this;
        return false;
    }

    public static void init() {
        SpawnPlacements.register((EntityType)((EntityType)DecodesignFunctionsAndBlocksModEntities.OYSTER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
        builder = builder.add(Attributes.MAX_HEALTH, 6.0);
        builder = builder.add(Attributes.ARMOR, 5.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add((Attribute)NeoForgeMod.SWIM_SPEED.value(), 0.0);
        return builder;
    }
}

