
package net.mcreator.medievalmod.fluid;

import net.minecraftforge.fluids.ForgeFlowingFluid;

import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.LiquidBlock;

import net.mcreator.medievalmod.init.MedievalmodModItems;
import net.mcreator.medievalmod.init.MedievalmodModFluids;
import net.mcreator.medievalmod.init.MedievalmodModFluidTypes;
import net.mcreator.medievalmod.init.MedievalmodModBlocks;

public abstract class MeltedSteelFluid extends ForgeFlowingFluid {
	public static final ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(
			() -> MedievalmodModFluidTypes.MELTED_STEEL_TYPE.get(), () -> MedievalmodModFluids.MELTED_STEEL.get(),
			() -> MedievalmodModFluids.FLOWING_MELTED_STEEL.get()).explosionResistance(100f)
			.bucket(() -> MedievalmodModItems.MELTED_STEEL_BUCKET.get()).block(() -> (LiquidBlock) MedievalmodModBlocks.MELTED_STEEL.get());

	private MeltedSteelFluid() {
		super(PROPERTIES);
	}

	public static class Source extends MeltedSteelFluid {
		public int getAmount(FluidState state) {
			return 8;
		}

		public boolean isSource(FluidState state) {
			return true;
		}
	}

	public static class Flowing extends MeltedSteelFluid {
		protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
			super.createFluidStateDefinition(builder);
			builder.add(LEVEL);
		}

		public int getAmount(FluidState state) {
			return state.getValue(LEVEL);
		}

		public boolean isSource(FluidState state) {
			return false;
		}
	}
}
