
package net.mcreator.mcdonaldsacauseisbored.fluid;

import net.minecraftforge.fluids.ForgeFlowingFluid;

import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.LiquidBlock;

import net.mcreator.mcdonaldsacauseisbored.init.McdonaldsAcauseIsBoredModItems;
import net.mcreator.mcdonaldsacauseisbored.init.McdonaldsAcauseIsBoredModFluids;
import net.mcreator.mcdonaldsacauseisbored.init.McdonaldsAcauseIsBoredModFluidTypes;
import net.mcreator.mcdonaldsacauseisbored.init.McdonaldsAcauseIsBoredModBlocks;

public abstract class CokeFluid extends ForgeFlowingFluid {
	public static final ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(() -> McdonaldsAcauseIsBoredModFluidTypes.COKE_TYPE.get(), () -> McdonaldsAcauseIsBoredModFluids.COKE.get(),
			() -> McdonaldsAcauseIsBoredModFluids.FLOWING_COKE.get()).explosionResistance(100.5f).bucket(() -> McdonaldsAcauseIsBoredModItems.COKE_BUCKET.get()).block(() -> (LiquidBlock) McdonaldsAcauseIsBoredModBlocks.COKE.get());

	private CokeFluid() {
		super(PROPERTIES);
	}

	public static class Source extends CokeFluid {
		public int getAmount(FluidState state) {
			return 8;
		}

		public boolean isSource(FluidState state) {
			return true;
		}
	}

	public static class Flowing extends CokeFluid {
		protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
			super.createFluidStateDefinition(builder);
			builder.add(LEVEL);
		}

		public int getAmount(FluidState state) {
			return state.getValue(LEVEL);
		}

		public boolean isSource(FluidState state) {
			return false;
		}
	}
}
