if (true) {
    int originRGB = ${input$Origin} & 0xFFFFFF;
    int destRGB = ${input$Destination} & 0xFFFFFF;

    int r1 = (originRGB >> 16) & 0xFF;
    int g1 = (originRGB >> 8) & 0xFF;
    int b1 = originRGB & 0xFF;

    int r2 = (destRGB >> 16) & 0xFF;
    int g2 = (destRGB >> 8) & 0xFF;
    int b2 = destRGB & 0xFF;

    int len = ${input$Text}.length();
    MutableComponent autoComponentCombined = Component.empty();

    for (int i = 0; i < len; i++) {
        float t = len <= 1 ? 0f : (float) i / (len - 1);

        int r = (int) (r1 + (r2 - r1) * t + 0.5f);
        int g = (int) (g1 + (g2 - g1) * t + 0.5f);
        int b = (int) (b1 + (b2 - b1) * t + 0.5f);

        r = r < 0 ? 0 : (r > 255 ? 255 : r);
        g = g < 0 ? 0 : (g > 255 ? 255 : g);
        b = b < 0 ? 0 : (b > 255 ? 255 : b);

        int colorInt = (r << 16) | (g << 8) | b;
        TextColor color = TextColor.fromRgb(colorInt);

        autoComponentCombined.append(
            Component.literal(String.valueOf(${input$Text}.charAt(i)))
                .withStyle(Style.EMPTY.withColor(color))
        );
    }

    ${input$ComponentReturned} = autoComponentCombined;
}
