<#include "procedures.java.ftl">
public class ${name}Procedure {

    public static ItemStack lastMainHandItem = ItemStack.EMPTY;

    static {
        if (net.fabricmc.loader.api.FabricLoader.getInstance().getEnvironmentType() == net.fabricmc.api.EnvType.CLIENT) {
            net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
                if (entityRenderer instanceof net.minecraft.client.renderer.entity.player.PlayerRenderer playerRenderer) {
                    net.fabricmc.fabric.api.client.rendering.v1.LivingEntityRenderEvents.PRE.register((livingEntity, renderer, partialTick, matrixStack, vertexConsumers, light) -> {
                        if (livingEntity instanceof net.minecraft.world.entity.LivingEntity living) {
                            ItemStack item = living.getMainHandItem();
                            if (item.is(net.minecraft.tags.ItemTags.create(new net.minecraft.resources.ResourceLocation("fabric:guns")))) {
                                if (renderer.getModel() instanceof net.minecraft.client.model.HumanoidModel<?> model) {
                                    model.rightArmPose = net.minecraft.client.model.HumanoidModel.ArmPose.BOW_AND_ARROW;

                                    model.rightArm.xRot = (float) Math.toRadians(-45);
                                    model.rightArm.yRot = (float) Math.toRadians(-5);
                                    model.rightArm.zRot = 0.0F;

                                    model.leftArm.xRot = (float) Math.toRadians(-30);
                                    model.leftArm.yRot = (float) Math.toRadians(15);
                                    model.leftArm.zRot = 0.0F;
                                }
                            }
                        }
                        return true;
                    });
                }
            });
        }
    }

    public static void onPlayerTick(net.minecraft.server.level.ServerPlayer player) {
        if (player != null) {
            ItemStack currentItem = player.getMainHandItem();
            if (currentItem.is(net.minecraft.tags.ItemTags.create(new net.minecraft.resources.ResourceLocation("fabric:guns")))) {
                player.swinging = false;
                player.swingTime = 0;
                player.swingingArm = null;
            }
            if (!ItemStack.isSameItemSameTags(currentItem, lastMainHandItem)) {
                if (currentItem.is(net.minecraft.tags.ItemTags.create(new net.minecraft.resources.ResourceLocation("fabric:guns"))) && !currentItem.isEmpty()) {
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.BLOCK_INTERACTION_RANGE).setBaseValue(0);
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.ENTITY_INTERACTION_RANGE).setBaseValue(0);
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.ATTACK_SPEED).setBaseValue(1024D);
                } else if (!lastMainHandItem.is(net.minecraft.tags.ItemTags.create(new net.minecraft.resources.ResourceLocation("fabric:guns"))) || currentItem.isEmpty()) {
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.BLOCK_INTERACTION_RANGE).setBaseValue(4.5D);
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.ENTITY_INTERACTION_RANGE).setBaseValue(3D);
                    player.getAttribute(net.minecraft.world.entity.ai.attributes.Attributes.ATTACK_SPEED).setBaseValue(4D);
                }
            }
            lastMainHandItem = currentItem.copy();
        }
    }
    
    static {
        if (net.fabricmc.loader.api.FabricLoader.getInstance().getEnvironmentType() == net.fabricmc.api.EnvType.CLIENT) {
            net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents.END_CLIENT_TICK.register(mc -> {
                net.minecraft.client.player.LocalPlayer player = mc.player;
                if (player != null) {
                    if (player.getMainHandItem().is(net.minecraft.tags.ItemTags.create(new net.minecraft.resources.ResourceLocation("fabric:guns")))) {
                        player.swinging = false;
                        player.swingTime = 0;
                        player.swingingArm = null;
                    }
                }
            });
        }
    }