@Mod.EventBusSubscriber
public class ${name}Procedure {

    public static ItemStack lastMainHandItem = ItemStack.EMPTY;

    @OnlyIn(Dist.CLIENT)
    @SubscribeEvent
    public static void onEventTriggered(RenderPlayerEvent.Pre event) {
        Entity entity = event.getEntity();
        ItemStack item = ItemStack.EMPTY;

        if (entity instanceof LivingEntity living) {
            item = living.getMainHandItem();
        }

        if (item.is(ItemTags.create(new ResourceLocation("neoforge", "guns")))) {
            PlayerModel<?> model = (PlayerModel<?>) event.getRenderer().getModel();

            model.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;

            model.rightArm.xRot = (float) Math.toRadians(-45);
            model.rightArm.yRot = (float) Math.toRadians(-5);
            model.rightArm.zRot = 0.0F;

            model.leftArm.xRot = (float) Math.toRadians(-30);
            model.leftArm.yRot = (float) Math.toRadians(15);
            model.leftArm.zRot = 0.0F;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity() instanceof Player player) {
            if (player.level().isClientSide) return;

            ItemStack currentItem = player.getMainHandItem();
            if (currentItem.is(ItemTags.create(new ResourceLocation("neoforge", "guns")))) {
                player.swinging = false;
                player.swingTime = 0;
                player.swingingArm = null;
            }

            if (!ItemStack.isSameItemSameTags(currentItem, lastMainHandItem)) {
                if (currentItem.is(ItemTags.create(new ResourceLocation("neoforge", "guns"))) && !currentItem.isEmpty()) {
                    player.getAttribute(NeoForgeMod.BLOCK_REACH.get()).setBaseValue(0);
                    player.getAttribute(NeoForgeMod.ENTITY_REACH.get()).setBaseValue(0);
                    player.getAttribute(Attributes.ATTACK_SPEED).setBaseValue(1024D);
                } else if (!lastMainHandItem.is(ItemTags.create(new ResourceLocation("neoforge", "guns"))) || currentItem.isEmpty()) {
                    player.getAttribute(NeoForgeMod.BLOCK_REACH.get()).setBaseValue(4.5D);
                    player.getAttribute(NeoForgeMod.ENTITY_REACH.get()).setBaseValue(3D);
                    player.getAttribute(Attributes.ATTACK_SPEED).setBaseValue(4D);
                }
            }
            lastMainHandItem = currentItem.copy();
        }
    }

    @OnlyIn(Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            if (player.getMainHandItem().is(ItemTags.create(new ResourceLocation("neoforge", "guns")))) {
                player.swinging = false;
                player.swingTime = 0;
                player.swingingArm = null;
            }
        }
    }